########## LST coefficient calculations ##########

#install mplus automation package
install.packages("MplusAutomation")
require("MplusAutomation")

# For this code to work, the LST variance decomposition map in the data archive should be the working directory:
setwd("Research Archive\1. Data archive Stability over time\3. LST variance decomposition")
output <- readModels()
summary(output)

# obtaining unstandardized parameter estimates from output
df <- output$parameters$unstandardized
df <- subset(df, select = -c(pval,est_se))

# Selecting variance components from output
var.T <- df$est[73]
var.U1 <- df$est[74]
var.U2 <- df$est[75]
var.U3 <- df$est[76]
res.SA <- df$est[95:100]
res.JOY <- df$est[77:82]
res.VAL <- df$est[83:88]
res.BUR <- df$est[89:94]

# Selecting factor loadings from output
# note that factor loadings do not change over time, due to strong factorial invariance.
l.JOY <- df$est[1]
l.VAL <- df$est[2]
l.BUR <- df$est[3]

# Computing total observed variance for each indicator
var.JOY <- rep(0,6)
for (i in 1:6){
var.JOY[i] <- l.JOY^2*var.T+var.U1+res.JOY[i]+l.JOY^2*res.SA[i]
}

var.VAL <- rep(0,6)
for (i in 1:6){
  var.VAL[i] <- l.VAL^2*var.T+var.U2+res.VAL[i]+l.VAL^2*res.SA[i]
}

var.BUR <- rep(0,6)
for (i in 1:6){
  var.BUR[i] <- l.BUR^2*var.T+var.U3+res.BUR[i]+l.BUR^2*res.SA[i]
}

show <- data.frame(var.JOY, var.VAL, var.BUR)
show

# Calculating common consistency coefficient for each indicator
CON.JOY <- rep(0,6)
for (i in 1:6){
CON.JOY[i] <- (l.JOY^2*var.T+var.U1)/var.JOY[i]
}

CON.VAL <- rep(0,6)
for (i in 1:6){
  CON.VAL[i] <- (l.VAL^2*var.T+var.U2)/var.VAL[i]
}

CON.BUR <- rep(0,6)
for (i in 1:6){
  CON.BUR[i] <- (l.BUR^2*var.T+var.U3)/var.BUR[i]
}

show2 <- data.frame(CON.JOY, CON.VAL, CON.BUR)
show2

# Calculating Occasion specificity

SPE.JOY <- rep(0,6)
for (i in 1:6){
  SPE.JOY[i] <- (l.JOY^2*res.SA[i])/var.JOY[i]
}

SPE.VAL <- rep(0,6)
for (i in 1:6){
  SPE.VAL[i] <- (l.VAL^2*res.SA[i])/var.VAL[i]
}

SPE.BUR <- rep(0,6)
for (i in 1:6){
  SPE.BUR[i] <- (l.BUR^2*res.SA[i])/var.BUR[i]
}

show3 <- data.frame(SPE.JOY, SPE.VAL, SPE.BUR)
show3

# Calculating reliability coefficient: proportion of variance not due to unique state/measurement error
REL.JOY <- rep(0,6)
for (i in 1:6){
  REL.JOY[i] <- (l.JOY^2*var.T+var.U1+l.JOY^2*res.SA[i])/var.JOY[i]
}

REL.VAL <- rep(0,6)
for (i in 1:6){
  REL.VAL[i] <- (l.VAL^2*var.T+var.U2+l.VAL^2*res.SA[i])/var.VAL[i]
}

REL.BUR <- rep(0,6)
for (i in 1:6){
  REL.BUR[i] <- (l.BUR^2*var.T+var.U3+l.BUR^2*res.SA[i])/var.BUR[i]
}

show4 <- data.frame(REL.JOY, REL.VAL, REL.BUR)
show4

# Creating latex output for coefficient tables.
xtable(show2, label = "con", caption = "Consistency, specificity and reliability coefficients for the indicators of the LST model.")
xtable(show3, label = "spec", caption = "Consistency, specificity and reliability coefficients for the indicators of the LST model.")
xtable(show4, label = "rel", caption = "Consistency, specificity and reliability coefficients for the indicators of the LST model.")


# Ratio: Consistency/Occasion specificity = the 'times' more systematic variance is explained by trait than common state for an indicator.
ratio.JOY <- CON.JOY/SPE.JOY
ratio.VAL <- CON.VAL/SPE.VAL
ratio.BUR <- CON.BUR/SPE.BUR
show.ratio <- data.frame(ratio.JOY, ratio.VAL, ratio.BUR)
show.ratio

mean(ratio.JOY)
mean(ratio.VAL)
mean(ratio.BUR)

############ END OF CODE #################
